float4 rgb2hsv(float4 c) {
    float4 K = float4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
    float4 p = mix(float4(c.bg, K.wz), float4(c.gb, K.xy), step(c.b, c.g));
    float4 q = mix(float4(p.xyw, c.r), float4(c.r, p.yzx), step(p.x, c.r));
    float d = q.x - min(q.w, q.y);
    float e = 1.0e-10;
    return float4(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x, c.a);
}

float4 hsv2rgb(float4 c) {
    float4 K = float4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
    float3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);
    return float4(float3(c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y)), c.a);
}

float rand(float2 n) { 
    return fract(sin(dot(n, float2(12.9898, 4.1414))) * 43758.5453);
}

float4 mainImage(VertData v_in) : TARGET {
    return hsv2rgb(float4(
        0.0,
        0.0,
        rand(float2(v_in.uv.y + rand_f + 1, v_in.uv.x + rand_f)),
        rand(float2(v_in.uv.y + rand_f + 2, v_in.uv.x + rand_f))
    ));
}
