uniform float amount<
    string label = "Amount (0.0)";
    string widget_type = "slider";
    float minimum = -1000.0;
    float maximum = 1000.0;
    float step = 0.01;
> = 0.0;

float rand(float2 n) { 
    return fract(sin(dot(n, float2(12.9898, 4.1414))) * 43758.5453);
}

float4 mainImage(VertData v_in) : TARGET {
    v_in.uv.x -= amount / 640.0 * (rand_f * 2.0 - 1.0);
    if (v_in.uv.x < 0.0 || v_in.uv.x > 1.0) {
        return float4(0.0, 0.0, 0.0, 1.0);
    }
    return image.Sample(textureSampler, v_in.uv);
}
