uniform float amount<
    string label = "Fringing amount (0.5)";
    string widget_type = "slider";
    float minimum = 0.0;
    float maximum = 2.0;
    float step = 0.01;
> = 0.5;

uniform float res<
    string label = "Sample res (640.0)";
    string widget_type = "slider";
    float minimum = 1.0;
    float maximum = 2560.0;
    float step = 1.0;
> = 640.0;

uniform float iangle<
    string label = "Angle (29.97)";
    string widget_type = "slider";
    float minimum = -1000.0;
    float maximum = 1000.0;
    float step = 0.01;
> = 29.97;

uniform float scroll<
    string label = "Scroll (15.0)";
    string widget_type = "slider";
    float minimum = -10000.0;
    float maximum = 10000.0;
    float step = 0.01;
> = 15.0;

float4 rgb2yiq(float4 rgb) {
    float y = 0.30 * rgb.x + 0.59 * rgb.y + 0.11 * rgb.z;
    return float4(y, -0.27 * (rgb.z-y) + 0.74 * (rgb.x-y), 0.41 * (rgb.z-y) + 0.48 * (rgb.x-y), rgb.a);
}

float4 yiq2rgb(float4 yiq) {
    return float4(yiq.x + 0.9469*yiq.y + 0.6236*yiq.z, yiq.x - 0.2748*yiq.y - 0.6357*yiq.z, yiq.x - 1.1*yiq.y + 1.7*yiq.z, yiq.a);
}

float4 rgb2hsv(float4 c) {
    float4 K = float4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
    float4 p = mix(float4(c.bg, K.wz), float4(c.gb, K.xy), step(c.b, c.g));
    float4 q = mix(float4(p.xyw, c.r), float4(c.r, p.yzx), step(p.x, c.r));

    float d = q.x - min(q.w, q.y);
    float e = 1.0e-10;
    return float4(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x, c.a);
}

float4 hsv2rgb(float4 c) {
    float4 K = float4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
    float3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);
    return float4(float3(c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y)), c.a);
}

float4 getpix(float2 coord) {
    if (coord.x < 0.0) {
        return float4(0.0, 0.0, 0.0, 1.0);
    }
    return image.Sample(textureSampler, coord);
}

float rand(float2 n) { 
    return fract(sin(dot(n, float2(12.9898, 4.1414))) * 43758.5453);
}

float4 mainImage(VertData v_in) : TARGET {
    float4 pix = image.Sample(textureSampler, v_in.uv);
    float4 pix2 = getpix(float2(v_in.uv.x - 1 / res, v_in.uv.y));
    float4 hsv = rgb2hsv(pix);
    float4 hsv2 = rgb2hsv(pix2);
    float val = abs(hsv.z - hsv2.z);
    float angle = iangle * (val * 0.1 + 0.9);
    float rand1 = v_in.uv.x + v_in.uv.y * angle + mod(elapsed_time, 1000) * scroll * (rand(float2(val, v_in.uv.x + v_in.uv.y * angle)) * 0.000001 + 1.0);
    float rand2 = rand(float2(v_in.uv.y + rand_f + 1, v_in.uv.x * angle));
    float rand3 = rand(float2(v_in.uv.y + rand_f + 2, v_in.uv.x + v_in.uv.y * angle)) / 2 + 0.5;
    //hsv.x += rand3 * val;
    val *= amount;
    hsv.y = mix(hsv.y, 1, val);
    //hsv.z = mix(hsv.z, 1, val);
    float4 rgb = hsv2rgb(hsv);
    float4 rgb2 = hsv2rgb(float4(rand1, 1.0, hsv.z, hsv.a));
    return mix(rgb, rgb2, val);
}
