$CONSOLE
_CONSOLE ON
CHDIR "oskcfg"
DIM TMPONE AS LONG
TMPONE = _RGBA32(127, 127, 127, 220)
OPEN "wac.var" FOR OUTPUT AS #4
WRITE #4, TMPONE
CLOSE #4
CHDIR ".."
ARG$ = " " + COMMAND$ + " "
ARG$ = LCASE$(ARG$)
DIM SHARED NOLOG
IF INSTR(1, ARG$, " -nolog ") THEN NOLOG = 1
LOG "Starting OSKRNL..."
LOG "Command line arguments: " + COMMAND$
IF INSTR(1, ARG$, " -help ") > 0 THEN
    LOG "Displaying command line help..."
    $CONSOLE
    _ECHO "-smlscr 0 runs OSKRNL in 320x200"
    _ECHO "-smlscr 1 runs OSKRNL in 640x480"
    _ECHO "-smlscr 2 runs OSKRNL in 800x600"
    _ECHO "-smlscr 3 runs OSKRNL in 1024x768"
    _ECHO "-nolog disables the log"
    _ECHO "-help displays this screen"
    LOG "Exiting OSKRNL..."
    CLOSELOG
    SYSTEM
END IF
_CONSOLE OFF
ON ERROR GOTO CRASH
_TITLE "OSKRNL v0.0.3.2 Beta (Open Source)"
_MOUSEHIDE
_FULLSCREEN , _SMOOTH
_SCREENSHOW
LOG "Set initial settings."
OSBOOT:
SCREEN 0
_AUTODISPLAY
_FULLSCREEN , _SMOOTH
IF CONFIG = 0 THEN
    LOG "Configuring OSKRNL..."
    DIM SHARED DTC AS LONG
    DIM SHARED WAC AS LONG
    DIM SHARED WBC AS LONG
    DIM SHARED CLCLR AS LONG
    DIM SHARED LOGOPEN AS SINGLE
    CHDIR "oskcfg"
    OPEN "welcome.var" FOR INPUT AS 2
    INPUT #2, WELCOME
    CLOSE #2
    OPEN "mouse.var" FOR INPUT AS 2
    INPUT #2, MOUSE
    CLOSE #2
    OPEN "dtc.var" FOR INPUT AS 2
    INPUT #2, DTC
    CLOSE #2
    OPEN "wac.var" FOR INPUT AS 2
    INPUT #2, WAC
    CLOSE #2
    OPEN "wbc.var" FOR INPUT AS 2
    INPUT #2, WBC
    CLOSE #2
    OPEN "fce.var" FOR INPUT AS 2
    INPUT #2, FCE
    CLOSE #2
    OPEN "cur.var" FOR INPUT AS 2
    INPUT #2, CF$
    CLOSE #2
    CHDIR ".."
    CONFIG = 1
END IF
IF CF$ = "_" THEN CF$ = "default.csr"
LOG "Configuration complete."
LOCATE 1, 1, 1
_DELAY 0.1145
LOCATE , , 0
CHDIR "oskcfg"
CHDIR "bootscr"
LOG "Showing boot screen..."
SCREEN _NEWIMAGE(320, 200, 32), , 0, 0
SCREEN _LOADIMAGE("0.bmp", 32)
LOG "Playing startup sound..."
CHDIR ".."
CHDIR ".."
_SNDPLAYFILE "startup.wav", , 1
CHDIR "oskcfg"
CHDIR "bootscr"
_AUTODISPLAY
BSCRL = 0
DO
    SCREEN _LOADIMAGE("0.bmp", 32)
    _DELAY 0.1
    SCREEN _LOADIMAGE("1.bmp", 32)
    _DELAY 0.1
    SCREEN _LOADIMAGE("2.bmp", 32)
    _DELAY 0.1
    SCREEN _LOADIMAGE("3.bmp", 32)
    _DELAY 0.1
    SCREEN _LOADIMAGE("4.bmp", 32)
    _DELAY 0.1
    SCREEN _LOADIMAGE("5.bmp", 32)
    _DELAY 0.1
    SCREEN _LOADIMAGE("6.bmp", 32)
    _DELAY 0.1
    SCREEN _LOADIMAGE("7.bmp", 32)
    _DELAY 0.1
    SCREEN _LOADIMAGE("8.bmp", 32)
    _DELAY 0.1
    SCREEN _LOADIMAGE("9.bmp", 32)
    _DELAY 0.1
    SCREEN _LOADIMAGE("10.bmp", 32)
    _DELAY 0.1
    SCREEN _LOADIMAGE("11.bmp", 32)
    _DELAY 0.1
    SCREEN _LOADIMAGE("12.bmp", 32)
    _DELAY 0.1
    SCREEN _LOADIMAGE("13.bmp", 32)
    _DELAY 0.1
    SCREEN _LOADIMAGE("14.bmp", 32)
    _DELAY 0.1
    SCREEN _LOADIMAGE("15.bmp", 32)
    _DELAY 0.1
    SCREEN _LOADIMAGE("16.bmp", 32)
    _DELAY 0.1
    SCREEN _LOADIMAGE("17.bmp", 32)
    _DELAY 0.1
    SCREEN _LOADIMAGE("18.bmp", 32)
    _DELAY 0.1
    BSCRL = BSCRL + 1
LOOP WHILE BSCRL < 2
_DISPLAY
CHDIR ".."
CHDIR ".."
_DELAY 1.57
SCREEN _NEWIMAGE(_DESKTOPWIDTH, _DESKTOPHEIGHT, 32), , 0, 1: RES$ = "desktop"
IF INSTR(1, ARG$, " -smlscr 0 ") > 0 THEN SCREEN _NEWIMAGE(320, 200, 32), , 0, 1: RES = 0: RES$ = "320x200 (reduced resolution mode)"
IF INSTR(1, ARG$, " -smlscr 1 ") > 0 THEN SCREEN _NEWIMAGE(640, 480, 32), , 0, 1: RES = 1: RES$ = "640x480 (reduced resolution mode)"
IF INSTR(1, ARG$, " -smlscr 2 ") > 0 THEN SCREEN _NEWIMAGE(800, 600, 32), , 0, 1: RES = 2: RES$ = "800x600 (reduced resolution mode)"
IF INSTR(1, ARG$, " -smlscr 3 ") > 0 THEN SCREEN _NEWIMAGE(1024, 768, 32), , 0, 1: RES = 3: RES$ = "1024x768 (reduced resolution mode)"
SCREEN , , 0, 1
LOG "Set screen resolution to " + RES$ + "."
IF FCE = 1 THEN LOG "Executing fancy curtain effect..."
YDA = _HEIGHT
DO WHILE YDA > 0 AND FCE = 1
    LINE (0, YDA)-(_WIDTH, YDA), DTC
    PCOPY 0, 1
    _DISPLAY
    YDA = YDA - 1
    _DELAY 0
LOOP
LOG "Starting graphical desktop..."
CLS 0, DTC
PCOPY 0, 1
_DISPLAY
_FULLSCREEN , _SMOOTH
_FONT 14
LOCATE , , 1
_PRINTMODE _KEEPBACKGROUND
LOCATE 1, 1, 0
LOG "Finding cursor file..."
IF NOT _FILEEXISTS(CF$) THEN
    IF NOT _FILEEXISTS("default.csr") THEN
        LOG "Cursor file not found. Mouse disabled."
        MOUSE = 0
        DRWDLG _WIDTH / 2 - 238, _HEIGHT / 2 - 82, 460, 40, "Could not find '" + CF$ + "'", "Press space to clear.", "", "", "", ""
        PCOPY 0, 1
        _DISPLAY
        DO
            IK$ = INKEY$
            IF IK$ = CHR$(27) THEN SHUTDOWN "Exiting OSKRNL...", 7, 0, 0.35, 0: EXIT DO
            IF IK$ = " " THEN CLS 0, DTC: EXIT DO
            IF IK$ = CHR$(0) + CHR$(103) THEN
                RESTART "Please wait while OSKRNL restarts...", 3
                IF MOUSE = 1 THEN _FREEIMAGE CUR&
                GOTO OSBOOT
                EXIT DO
            END IF
            IF IK$ = CHR$(0) + CHR$(97) THEN ERROR 0: EXIT DO
        LOOP UNTIL IK$ <> ""
    ELSE
        CF$ = "default.csr"
    END IF
END IF
CUR& = _LOADIMAGE(CF$, 32)
_MOUSEMOVE _WIDTH / 2, _HEIGHT / 2
PCOPY 0, 1
IF WELCOME = 1 THEN
    LOG "Showing welcome dialog..."
    DRWDLG _WIDTH / 2 - 236, _HEIGHT / 2 - 80, 460, 95, "Welcome!", "Welcome to OSKRNL v0.0.3.2 Beta!", "Press ESC to exit or ALT+F4/CTRL+BREAK to force close.", "Press CTRL+F10 to restart.", "For debugging: CTRL+F4 to crash.", "Press SPACE to clear."
    PCOPY 0, 1
    _DISPLAY
    DO
        IK$ = INKEY$
        IF IK$ = CHR$(27) THEN SHUTDOWN "Exiting OSKRNL...", 7, 0, 0.35, 0: EXIT DO
        IF IK$ = " " THEN CLS 0, DTC: EXIT DO
        IF IK$ = CHR$(0) + CHR$(103) THEN
            RESTART "Please wait while OSKRNL restarts...", 3
            IF MOUSE = 1 THEN _FREEIMAGE CUR&
            GOTO OSBOOT
            EXIT DO
        END IF
        IF IK$ = CHR$(0) + CHR$(97) THEN ERROR 0: EXIT DO
    LOOP
END IF
PCOPY 0, 1
_DISPLAY
LOG "Executing main duty cycle..."
DO
    IK$ = INKEY$
    IF IK$ = CHR$(27) THEN SHUTDOWN "Exiting OSKRNL...", 7, 0, 0.35, 0
    IF IK$ = CHR$(0) + CHR$(103) THEN
        RESTART "Please wait while OSKRNL restarts...", 3
        IF MOUSE = 1 THEN _FREEIMAGE CUR&
        GOTO OSBOOT
    END IF
    IF IK$ = CHR$(0) + CHR$(97) THEN ERROR 0
    DO WHILE _MOUSEINPUT AND MSMV = 0 AND MOUSE = 1
        IK$ = INKEY$
        MSX = _MOUSEX
        MSY = _MOUSEY
        EXIT DO
    LOOP
    DO WHILE _MOUSEINPUT AND MSMV = 1 AND MOUSE = 1
        IF MSX <> _MOUSEX OR MSY <> _MOUSEY THEN
            RMS:
            IK$ = INKEY$
            MSX = _MOUSEX
            MSY = _MOUSEY
            SCREEN , , 1, 1
            PCOPY 0, 1
            _PUTIMAGE (MSX, MSY), CUR&
            SCREEN , , 0, 1
            _DISPLAY
        END IF
    LOOP
    IF MSX <> _MOUSEX OR MSY <> _MOUSEY THEN MSMV = 1
LOOP
CRASH:
CRASH
RS:
RESTART "Please wait while OSKRNL restarts...", 3
RETURN

' SUBS

SUB DRWWIN (X, Y, XS, YS, T$)
    XS = X + XS
    YS = Y + YS
    XS = XS - 1
    YS = YS - 1
    LINE (X, Y)-(XS, YS), WAC, BF
    LINE (X, Y)-(XS, YS), 15, B
    LINE (X + 1, Y + 1)-(XS - 1, YS - 1), WBC, B
    LINE (X + 2, Y + 18)-(XS - 2, Y + 19), WBC, B
    COLOR , CLCLR
    _PRINTSTRING (X + 4, Y + 4), T$
    _DISPLAY
END SUB
SUB DRWDLG (X, Y, XS, YS, T$, T1$, T2$, T3$, T4$, T5$)
    XS = X + XS
    YS = Y + YS
    XS = XS - 1
    YS = YS - 1
    DWLC = Y + 1
    LINE (X, Y)-(XS, YS), WAC, BF
    LINE (X, Y)-(XS, YS), 15, B
    LINE (X + 1, Y + 1)-(XS - 1, YS - 1), WBC, B
    LINE (X + 2, Y + 18)-(XS - 2, Y + 19), WBC, B
    COLOR , CLCLR
    _PRINTSTRING (X + 4, Y + 4), T$
    _PRINTSTRING (X + 4, Y + 22), T1$
    _PRINTSTRING (X + 4, Y + 36), T2$
    _PRINTSTRING (X + 4, Y + 50), T3$
    _PRINTSTRING (X + 4, Y + 64), T4$
    _PRINTSTRING (X + 4, Y + 78), T5$
    _DISPLAY
END SUB
SUB DRWBTN (X, Y, XS, YS, T$)
    LINE (X, Y)-(X + XS, Y + YS), WAC, BF
    LINE (X + 1, Y + 1)-(X + XS - 1, Y + YS - 1), WBC, B
    COLOR _RGB(0, 0, 0), CLCLR
    _PRINTSTRING (X + 3, Y + 3), T$
END SUB
SUB SHUTDOWN (T$, FG, BG, W, P)
    _AUTODISPLAY
    SCREEN 0
    COLOR FG, BG
    CLS 0, BG
    LOCATE 1, 1, 1
    PRINT T$;
    LOG T$
    CLOSELOG
    _DELAY W
    IF P <> 0 THEN PRINT CHR$(13); "Press any key to continue...";: SLEEP
    SYSTEM
END SUB
SUB RESTART (T$, W)
    LOG T$
    DRWDLG _WIDTH / 2 - 234, _HEIGHT / 2 - 74, 460, 40, "Restarting OSKRNL", T$, "", "", "", ""
    SCREEN , , 1, 1
    PCOPY 0, 1
    SCREEN , , 0, 1
    _DISPLAY
    _DELAY W
    LOG "Restart successfull."
END SUB
SUB CRASH
    _AUTODISPLAY
    SCREEN 0
    COLOR 7, 1
    CLS 0, 1
    LOCATE 1, 1, 1
    LOG "/CRASH_REPORT"
    PRINT "OSKRNL has crashed. The details were logged."
    CLOSELOG
    _DELAY W
    PRINT "Press any key to continue...";: SLEEP
    SYSTEM
END SUB
SUB RFCUR (F$)
    CUR& = _LOADIMAGE(F$, 32)
END SUB
SUB LOG (T$)
    IF NOLOG = 0 THEN
        IF LOGOPEN = 0 THEN
            OPEN "oskrnl.log" FOR APPEND AS #1
            PRINT #1, "--------------------------------------------------------------------------------"
            PRINT #1, "## LOG OPENED AT " + TIME$ + ": " + DATE$ + " ##"
            LOGOPEN = 1
        END IF
        IF T$ = "/CRASH_REPORT" THEN
            OPEN "errtemp.var" FOR OUTPUT AS #3
            WRITE #3, ERR
            CLOSE #3
            OPEN "errtemp.var" FOR INPUT AS #3
            LINE INPUT #3, ERR$
            CLOSE #3
            KILL "errtemp.var"
            OPEN "errtemp.var" FOR OUTPUT AS #3
            WRITE #3, _ERRORLINE
            CLOSE #3
            OPEN "errtemp.var" FOR INPUT AS #3
            LINE INPUT #3, ERRLN$
            CLOSE #3
            KILL "errtemp.var"
            PRINT #1, TIME$ + ": "; "OSKRNL crashed: Error ";
            IF ERR = 1 THEN PRINT #1, ERR$; ": " + "NEXT without FOR";
            IF ERR = 2 THEN PRINT #1, ERR$; ": " + "Syntax error";
            IF ERR = 3 THEN PRINT #1, ERR$; ": " + "RETURN without GOSUB";
            IF ERR = 4 THEN PRINT #1, ERR$; ": " + "Out of DATA";
            IF ERR = 5 THEN PRINT #1, ERR$; ": " + "Illegal function call";
            IF ERR = 6 THEN PRINT #1, ERR$; ": " + "Overflow";
            IF ERR = 7 THEN PRINT #1, ERR$; ": " + "Out of memory";
            IF ERR = 8 THEN PRINT #1, ERR$; ": " + "Label not defined";
            IF ERR = 9 THEN PRINT #1, ERR$; ": " + "Subscript out of range";
            IF ERR = 10 THEN PRINT #1, ERR$; ": " + "Duplicate definition";
            IF ERR = 11 THEN PRINT #1, ERR$; ": " + "Division by zero";
            IF ERR = 12 THEN PRINT #1, ERR$; ": " + "Illegal in direct mode";
            IF ERR = 13 THEN PRINT #1, ERR$; ": " + "Type mismatch";
            IF ERR = 14 THEN PRINT #1, ERR$; ": " + "Out of string space;"
            IF ERR = 16 THEN PRINT #1, ERR$; ": " + "String formula too complex";
            IF ERR = 17 THEN PRINT #1, ERR$; ": " + "Cannot continue";
            IF ERR = 18 THEN PRINT #1, ERR$; ": " + "Function not defined";
            IF ERR = 19 THEN PRINT #1, ERR$; ": " + "No RESUME";
            IF ERR = 20 THEN PRINT #1, ERR$; ": " + "RESUME without error";
            IF ERR = 24 THEN PRINT #1, ERR$; ": " + "Device timeout";
            IF ERR = 25 THEN PRINT #1, ERR$; ": " + "Device fault";
            IF ERR = 26 THEN PRINT #1, ERR$; ": " + "FOR without NEXT";
            IF ERR = 27 THEN PRINT #1, ERR$; ": " + "Out of paper";
            IF ERR = 29 THEN PRINT #1, ERR$; ": " + "WHILE without WEND";
            IF ERR = 30 THEN PRINT #1, ERR$; ": " + "WEND without WHILE";
            IF ERR = 33 THEN PRINT #1, ERR$; ": " + "Duplicate label";
            IF ERR = 35 THEN PRINT #1, ERR$; ": " + "Subprogram not defined";
            IF ERR = 37 THEN PRINT #1, ERR$; ": " + "Argument-count mismatch";
            IF ERR = 38 THEN PRINT #1, ERR$; ": " + "Array not defined";
            IF ERR = 40 THEN PRINT #1, ERR$; ": " + "Variable required";
            IF ERR = 50 THEN PRINT #1, ERR$; ": " + "FIELD overflow";
            IF ERR = 51 THEN PRINT #1, ERR$; ": " + "Internal error";
            IF ERR = 52 THEN PRINT #1, ERR$; ": " + "Bad file name or number";
            IF ERR = 53 THEN PRINT #1, ERR$; ": " + "File not found";
            IF ERR = 54 THEN PRINT #1, ERR$; ": " + "Bad file mode";
            IF ERR = 55 THEN PRINT #1, ERR$; ": " + "File already open";
            IF ERR = 56 THEN PRINT #1, ERR$; ": " + "FIELD statement active";
            IF ERR = 57 THEN PRINT #1, ERR$; ": " + "Device I/O error";
            IF ERR = 58 THEN PRINT #1, ERR$; ": " + "File already exists";
            IF ERR = 59 THEN PRINT #1, ERR$; ": " + "Bad record length";
            IF ERR = 61 THEN PRINT #1, ERR$; ": " + "Disk full";
            IF ERR = 62 THEN PRINT #1, ERR$; ": " + "Input past end of file";
            IF ERR = 63 THEN PRINT #1, ERR$; ": " + "Bad record number";
            IF ERR = 64 THEN PRINT #1, ERR$; ": " + "Bad file name";
            IF ERR = 67 THEN PRINT #1, ERR$; ": " + "Too many files";
            IF ERR = 68 THEN PRINT #1, ERR$; ": " + "Device unavailable";
            IF ERR = 69 THEN PRINT #1, ERR$; ": " + "Communication-buffer overflow";
            IF ERR = 70 THEN PRINT #1, ERR$; ": " + "Permission denied";
            IF ERR = 71 THEN PRINT #1, ERR$; ": " + "Disk not ready";
            IF ERR = 72 THEN PRINT #1, ERR$; ": " + "Disk-media error";
            IF ERR = 73 THEN PRINT #1, ERR$; ": " + "Feature unavailable";
            IF ERR = 74 THEN PRINT #1, ERR$; ": " + "Rename across disks";
            IF ERR = 75 THEN PRINT #1, ERR$; ": " + "Path/File access error";
            IF ERR = 76 THEN PRINT #1, ERR$; ": " + "Path not found";
            IF ERR = 97 THEN PRINT #1, ERR$; ": " + "Unknown";
            IF ERR = 258 THEN PRINT #1, ERR$; ": " + "Invalid handle";
            IF ERR = 0 THEN PRINT #1, ERR$; ": " + "Unknown";
            PRINT #1, " on line " + ERRLN$ + "."
        ELSE
            PRINT #1, TIME$ + ": " + T$
        END IF
    END IF
END SUB
SUB CLOSELOG
    IF LOGOPEN = 1 THEN
        PRINT #1, "## LOG CLOSED AT " + TIME$ + ": " + DATE$ + " ##"
        PRINT #1, "--------------------------------------------------------------------------------"
    END IF
END SUB

