_TITLE "PCIS Emulator"
RANDOMIZE USING TIMER
SCREEN _NEWIMAGE(640, 480, 256)
_DISPLAY
_FONT 8
C& = 0
T# = TIMER
DIM SHARED PC~&
PC~& = -1
CPUSPD& = 2000000
CDELAY& = CPUSPD&
CPU_ON = 0
DIM SHARED WRAM(0 TO 2097151) AS _UNSIGNED _BYTE
FPS = 0
OPEN "BOOT.BIN" FOR BINARY AS #1
DO
    _LIMIT CDELAY&
    IF C& < CDELAY& AND CPU_ON = 1 THEN
        PC~& = PC~& + 1
        CI~%% = RADDR(PC~&)
        C& = C& + 1
    END IF
    IF TIMER(.001) - D# >= 1 / 60 THEN
        _DISPLAY: FPS = FPS + 1: D# = TIMER(.001)
    END IF
    IF TIMER - T# >= 1 THEN
        'PRINT (CPUSPD& - C&)
        IF C& < CPUSPD& AND CPU_ON = 1 THEN CDELAY& = CPUSPD& + (CPUSPD& - C&) * 0.25
        IF C& > CPUSPD& AND CPU_ON = 1 THEN CDELAY& = CPUSPD&
        COLOR 15
        LOCATE 1, 1: PRINT SPACE$(80);
        LOCATE 2, 1: PRINT SPACE$(80);
        LOCATE 1, 1: PRINT CPUSPD&; CDELAY&; C&; FPS
        PRINT PC~&; CI~%%;
        _DISPLAY
        C& = 0: FPS = 0: T# = TIMER
        CPU_ON = 1
    END IF
    'WADDR RND * 4294967295, 1
    'WADDR 270532608 + CINT(RND * 10) + CINT(RND * 30720) * 10, CINT(RND * 255)
LOOP
SUB WADDR (ADDR~&, V~%%)
    IF ADDR~& >= 268435456 THEN
        ADDR~& = ADDR~& - 268435456
        IF ADDR~& >= 2097152 THEN
            VMP = ADDR~& - 2097152
            VY = INT(VMP / 640)
            VX = VMP - VY * 640
            PSET (VX, VY), V~%%
        ELSE
            WRAM(ADDR~&) = V~%%
        END IF
    END IF
END SUB
FUNCTION RADDR~%% (ADDR~&)
    IF ADDR~& > 268435455 THEN
        ADDR~& = ADDR~& - 268435456
        IF ADDR~& > 2097151 THEN
            VMP = ADDR~& - 2097152
            VY = INT(VMP / 640)
            VX = VMP - VY * 640
            RADDR~%% = POINT(VX, VY)
        ELSE
            RADDR~%% = WRAM(ADDR~&)
        END IF
    ELSE
        GET #1, ADDR~& + 1, RADDR~%%
    END IF
END FUNCTION
