_TITLE "Digitus Map Maker"
SCREEN _NEWIMAGE(640, 480, 32)
INPUT "Map Folder: ", MFLD$
MFLD$ = UCASE$(_TRIM$(MFLD$))
IF NOT _DIREXISTS("DATA") THEN MKDIR "DATA"
CHDIR "DATA"
IF NOT _DIREXISTS("MAPS") THEN MKDIR "MAPS"
CHDIR "MAPS"
IF _DIREXISTS(MFLD$) THEN
    PRINT MFLD$ + " already exists. ";
    INPUT "Replace?: ", YN$
    IF UCASE$(LEFT$(_TRIM$(TN$), 1)) = "Y" THEN PRINT "BRUH": SLEEP
    IF _DIREXISTS(MFLD$) THEN RMD MFLD$
END IF
MKDIR MFLD$
CHDIR MFLD$
MKDIR "TILES"
MKDIR "DAT"


OPEN "00.DAT" FOR BINARY AS #1 'Header
' Name$, ID, Width, Height, Animation_Speed


OPEN "01.DAT" FOR BINARY AS #2 'Tile data
' 0-255 = DATA/MAPS/*/TILES/*


OPEN "02.DAT" FOR BINARY AS #3 'Animation tile data
' 0 = No animation, 1-255 = # of tiles to advance by before loop


OPEN "03.DAT" FOR BINARY AS #4 'Tile type
' 0 = None/floor, 1 = Door, 2 = Trapdoor, 3 = Sign, 4 = Poster/Image Sign, 5 = Shop, 6 = Deadly, 127 = Save, 255 = Glitch


OPEN "04.DAT" FOR BINARY AS #5 'Tile options
' 0 = None/Default, 1-255 = DAT/*.DAT


OPEN "05.DAT" FOR BINARY AS #6 'Tile collision data
' 0 = None, 1 = All, 2 = Top, 3 = Bottom, 4 = Left, 5 = Right


OPEN "06.DAT" FOR BINARY AS #7 'Object data
' 0 = Nothing, 1 = Normal person, 2 = Poor person, 3 = Rich person, 4 = Merchant, 5 = Weapon


OPEN "07.DAT" FOR BINARY AS #8 'Object options
' 0 = None/Default, 1-255 = DAT/*.DAT


' If the byte is not in the correct range, it may produce an error or be the same as 0
' (eg. 250 in 03.DAT will be the same as 0 while 27 in 04.DAT in the absense of DAT/1B.DAT will cause an error).


DIM SHARED D00 AS STRING
INPUT "Name: ", NAME$
INPUT "ID: ", ID
INPUT "Width: ", MW
INPUT "Height: ", MH
INPUT "Animation Speed (ms): ", ASPEED

DIM SHARED D01 AS _UNSIGNED _BYTE
DIM SHARED D02 AS _UNSIGNED _BYTE
DIM SHARED D03 AS _UNSIGNED _BYTE
DIM SHARED D04 AS _UNSIGNED _BYTE
DIM SHARED D05 AS _UNSIGNED _BYTE
DIM SHARED D06 AS _UNSIGNED _BYTE
DIM SHARED D07 AS _UNSIGNED _BYTE

SUB RMD (DIR$)
    IF INSTR(_OS$, "WINDOWS") <> 0 THEN
        SHELL _HIDE "del /R /F /Q " + DIR$
    ELSE
        SHELL _HIDE "rm -rf " + DIR$
    END IF
END SUB
