/*
 * Decompiled with CFR 0.152.
 */
package ml.tcoded.nochatreports.hook;

import com.dominikkorsa.discordintegration.Client;
import com.dominikkorsa.discordintegration.DiscordIntegration;
import discord4j.core.spec.WebhookExecuteSpec;
import java.util.List;
import java.util.function.Consumer;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import ml.tcoded.nochatreports.NoChatReportsSpigot;
import ml.tcoded.nochatreports.event.AsyncPostNonReportableChatEvent;
import ml.tcoded.nochatreports.hook.AbstractHook;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class DiscordIntegrationHook
extends AbstractHook
implements Listener {
    private DiscordIntegration api;

    public DiscordIntegrationHook(NoChatReportsSpigot pluginIn) {
        super(pluginIn);
    }

    @Override
    public void onInit() {
        Plugin rawApi = this.plugin.getServer().getPluginManager().getPlugin("DiscordIntegration");
        if (!(rawApi instanceof DiscordIntegration)) {
            return;
        }
        DiscordIntegration fullApi = (DiscordIntegration)rawApi;
        this.api = fullApi;
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void onDisable() {
        HandlerList.unregisterAll((Listener)this);
        this.api = null;
    }

    @EventHandler
    public void onNonReportableChat(AsyncPostNonReportableChatEvent event) {
        String discordMsg = this.api.getDiscordFormatter().formatMessageContent(event.getMessage());
        Client client = this.api.getClient();
        WebhookExecuteSpec.Builder playerWebhookBuilder = (WebhookExecuteSpec.Builder)client.getPlayerWebhookBuilder(event.getPlayer(), new ConsumerContinuation<WebhookExecuteSpec.Builder>(o -> {}));
        if (playerWebhookBuilder == null) {
            return;
        }
        playerWebhookBuilder.content(discordMsg);
        WebhookExecuteSpec built = playerWebhookBuilder.build();
        client.sendWebhook(built, new ConsumerContinuation<List>(o -> {}));
    }

    private static class ConsumerContinuation<T>
    implements Continuation<T> {
        Consumer<T> consumer;

        public ConsumerContinuation(Consumer<T> consumerIn) {
            this.consumer = consumerIn;
        }

        @NotNull
        public CoroutineContext getContext() {
            return EmptyCoroutineContext.INSTANCE;
        }

        public void resumeWith(@NotNull Object o) {
            this.consumer.accept(o);
        }
    }
}

