/*
 * Decompiled with CFR 0.152.
 */
package ml.tcoded.nochatreports;

import java.util.HashMap;
import ml.tcoded.nochatreports.hook.AbstractHook;
import ml.tcoded.nochatreports.hook.DiscordIntegrationHook;
import ml.tcoded.nochatreports.hook.DiscordSRVHook;
import ml.tcoded.nochatreports.hook.EssentialsXDiscordHook;
import ml.tcoded.nochatreports.listener.ChatListener;
import ml.tcoded.nochatreports.listener.WhisperListener;
import ml.tcoded.nochatreports.util.UpdateUtil;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public final class NoChatReportsSpigot
extends JavaPlugin {
    private final HashMap<Class<? extends AbstractHook>, AbstractHook> hooks = new HashMap();

    public void onEnable() {
        this.initHooks();
        this.getServer().getPluginManager().registerEvents((Listener)new ChatListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new WhisperListener(), (Plugin)this);
        UpdateUtil.checkUpdate(this);
    }

    private void initHooks() {
        this.getLogger().info("Loading plugin hooks...");
        PluginManager pluginManager = this.getServer().getPluginManager();
        if (pluginManager.getPlugin("EssentialsDiscord") != null) {
            try {
                this.hooks.put(EssentialsXDiscordHook.class, new EssentialsXDiscordHook(this));
            }
            catch (Exception ex) {
                this.getLogger().warning("Failed to load EssentialsXDiscordHook! Please contact me on discord if this is not expected. The discord server is linked in the plugin description on spigotmc.");
            }
        }
        if (pluginManager.getPlugin("DiscordIntegration") != null) {
            try {
                this.hooks.put(DiscordIntegrationHook.class, new DiscordIntegrationHook(this));
            }
            catch (Exception ex) {
                this.getLogger().warning("Failed to load DiscordIntegrationHook! Please contact me on discord if this is not expected. The discord server is linked in the plugin description on spigotmc.");
            }
        }
        if (pluginManager.getPlugin("DiscordSRV") != null) {
            try {
                this.hooks.put(DiscordSRVHook.class, new DiscordSRVHook(this));
            }
            catch (Exception ex) {
                this.getLogger().warning("Failed to load DiscordSRVHook! Please contact me on discord if this is not expected. The discord server is linked in the plugin description on spigotmc.");
            }
        }
        this.hooks.values().forEach(AbstractHook::init);
        this.getLogger().info("Loaded " + this.hooks.size() + " plugin hooks!");
    }

    public void onDisable() {
        this.getLogger().info("Unloading plugin hooks...");
        this.hooks.values().forEach(AbstractHook::disable);
        this.hooks.clear();
        this.getLogger().info("Unloaded all plugin hooks!");
        HandlerList.unregisterAll((Plugin)this);
    }

    public ConsoleCommandSender getConsoleSender() {
        return this.getServer().getConsoleSender();
    }
}

